<?php
require_once __DIR__ . '/config.php';

function register_user($phone, $address, $password) {
    global $mysqli;
    $pass_hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $mysqli->prepare("INSERT INTO users (phone, address, password) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $phone, $address, $pass_hash);
    return $stmt->execute();
}

function login_user($phone, $password) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT id, password FROM users WHERE phone = ?");
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();
    if ($res && password_verify($password, $res['password'])) {
        return $res['id'];
    }
    return false;
}
?>