<?php
require_once __DIR__ . '/../app/product_model.php';
require_once __DIR__ . '/../app/order_model.php';
session_start();
$id = intval($_GET['id'] ?? 0);
$p = get_product($id);
if (!$p) { echo "محصول یافت نشد"; exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (empty($_SESSION['user_id'])) { header("Location: ../user/login.php"); exit; }
    $q = intval($_POST['quantity'] ?? 1);
    $res = create_order($_SESSION['user_id'], $id, $q);
    if ($res['ok']) header("Location: ../user/account.php");
    else $err = $res['error'];
}
?>
<!doctype html><html lang="fa"><head><meta charset="utf-8"><title><?php echo htmlspecialchars($p['title']); ?></title><link rel="stylesheet" href="../assets/style.css"></head><body>
<h2><?php echo htmlspecialchars($p['title']); ?></h2>
<?php if($p['image']): ?><img src="../uploads/<?php echo $p['image']; ?>" width="200"><?php endif; ?>
<p><?php echo nl2br(htmlspecialchars($p['description'])); ?></p>
<p>قیمت: <?php echo number_format($p['price']); ?> تومان</p>
<p>موجودی: <?php echo $p['stock']; ?></p>

<?php if(!empty($err)) echo "<p class='error'>$err</p>"; ?>

<?php if(isset($_SESSION['user_id'])): ?>
<form method="post">
  <label>تعداد</label><input type="number" name="quantity" value="1" min="1" max="<?php echo $p['stock']; ?>"><br>
  <button>ثبت سفارش (پرداخت حضوری)</button>
</form>
<?php else: ?>
  <p><a href="../user/login.php">برای سفارش وارد شوید</a></p>
<?php endif; ?>

</body></html>