<?php
require_once __DIR__ . '/config.php';

function add_product($title, $price, $stock, $description, $image) {
    global $mysqli;
    $stmt = $mysqli->prepare("INSERT INTO products (title, price, stock, description, image) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("siiss", $title, $price, $stock, $description, $image);
    return $stmt->execute();
}

function update_product($id, $title, $price, $stock, $description, $image = null) {
    global $mysqli;
    if ($image === null) {
        $stmt = $mysqli->prepare("UPDATE products SET title=?, price=?, stock=?, description=? WHERE id=?");
        $stmt->bind_param("siisi", $title, $price, $stock, $description, $id);
    } else {
        $stmt = $mysqli->prepare("UPDATE products SET title=?, price=?, stock=?, description=?, image=? WHERE id=?");
        $stmt->bind_param("siissi", $title, $price, $stock, $description, $image, $id);
    }
    return $stmt->execute();
}

function delete_product($id) {
    global $mysqli;
    $stmt = $mysqli->prepare("DELETE FROM products WHERE id = ?");
    $stmt->bind_param("i", $id);
    return $stmt->execute();
}

function get_product($id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

function list_products() {
    global $mysqli;
    return $mysqli->query("SELECT * FROM products ORDER BY id DESC");
}
?>