<?php
require_once __DIR__ . '/config.php';

function create_order($user_id, $product_id, $quantity) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT stock FROM products WHERE id = ?");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $row = $stmt->get_result()->fetch_assoc();
    if (!$row) return ["ok" => false, "error" => "محصول یافت نشد"];
    if ($row['stock'] < $quantity) return ["ok" => false, "error" => "موجودی کافی نیست"];

    $mysqli->begin_transaction();
    try {
        $stmt = $mysqli->prepare("UPDATE products SET stock = stock - ? WHERE id = ?");
        $stmt->bind_param("ii", $quantity, $product_id);
        $stmt->execute();

        $stmt = $mysqli->prepare("INSERT INTO orders (user_id, product_id, quantity) VALUES (?, ?, ?)");
        $stmt->bind_param("iii", $user_id, $product_id, $quantity);
        $stmt->execute();

        $mysqli->commit();
        return ["ok" => true];
    } catch (Exception $e) {
        $mysqli->rollback();
        return ["ok" => false, "error" => $e->getMessage()];
    }
}

function list_orders() {
    global $mysqli;
    return $mysqli->query("SELECT o.*, u.phone, p.title FROM orders o
                           JOIN users u ON u.id = o.user_id
                           JOIN products p ON p.id = o.product_id
                           ORDER BY o.id DESC");
}
?>