<?php
session_start();
if (empty($_SESSION['is_admin'])) { header("Location: login.php"); exit; }
require_once __DIR__ . '/../app/product_model.php';

// حذف محصول
if (isset($_GET['delete'])) {
    delete_product(intval($_GET['delete']));
    header("Location: products.php"); exit;
}

// پردازش فرم افزودن/ویرایش
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id'] ?? 0);
    $title = $_POST['title'] ?? '';
    $price = intval($_POST['price'] ?? 0);
    $stock = intval($_POST['stock'] ?? 0);
    $desc = $_POST['description'] ?? '';
    $image_name = null;
    if (!empty($_FILES['image']['name'])) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $image_name = time()."_".strval(rand(100,999)).".".$ext;
        move_uploaded_file($_FILES['image']['tmp_name'], __DIR__ . '/../uploads/' . $image_name);
    }

    if ($id > 0) {
        update_product($id, $title, $price, $stock, $desc, $image_name ? $image_name : null);
    } else {
        add_product($title, $price, $stock, $desc, $image_name);
    }
    header("Location: products.php"); exit;
}

$products = list_products();
?>
<!doctype html><html lang="fa"><head><meta charset="utf-8"><title>کالاها</title><link rel="stylesheet" href="../assets/style.css"></head><body>
<h2>مدیریت کالاها</h2>
<a href="dashboard.php">بازگشت</a>
<h3>افزودن / ویرایش کالا</h3>
<form method="post" enctype="multipart/form-data">
  <input type="hidden" name="id" value="">
  <label>نام</label><input name="title"><br>
  <label>قیمت</label><input name="price" type="number"><br>
  <label>موجودی</label><input name="stock" type="number"><br>
  <label>توضیحات</label><textarea name="description"></textarea><br>
  <label>عکس</label><input type="file" name="image"><br>
  <button>ذخیره</button>
</form>

<h3>لیست کالاها</h3>
<table border="1">
<tr><th>عکس</th><th>نام</th><th>قیمت</th><th>موجودی</th><th>عملیات</th></tr>
<?php while($r = $products->fetch_assoc()): ?>
<tr>
  <td><?php if($r['image']) echo '<img src="../uploads/'.$r['image'].'" width="80">'; ?></td>
  <td><?php echo htmlspecialchars($r['title']); ?></td>
  <td><?php echo number_format($r['price']); ?></td>
  <td><?php echo $r['stock']; ?></td>
  <td>
    <a href="products.php?edit=<?php echo $r['id']; ?>">ویرایش</a> |
    <a href="products.php?delete=<?php echo $r['id']; ?>" onclick="return confirm('حذف شود؟')">حذف</a>
  </td>
</tr>
<?php endwhile; ?>
</table>
</body></html>